# fgs

## Overview
fgs application provides commandline interface for Huawei FunctionGraph Service.

## Build
For Building the fgs application follow below steps.
        Run script `./build/build_fgs.sh`

Build will generate fgs pacakge "fgs-latest-package.tar.gz" in path `./build/package/`
The package consists of,
        1). fgs binary "fgs"
        2). fgs default configuration file "config.yaml"
        3). README file
## Installation
The fgs application can be directly used after untaring the build package “fgs-latest-package.tar.gz” and configuring the “config.yaml” file.
tar -zxvf fgs-latest-package.tar.gz
The fgs application can be executed by running the application as,
./fgs

## Usage
```
fgs --help                      // Lists all the options and subcommands
fgs create-function --help      // Lists details of create-function subcommand and flags.
fgs cf -n testfunc -f code.py   // Create function with only mandatory parameters.
                                    // (Function code provided using ./code.py file given below.)

fgs list-function               // Lists functions using provided config.yaml.
```

##Configuration Parameters
The following mandatory parameters need to be configured in the fgs configuration file, config.yaml.
1.	AccessKey:
        User AccessKey (ak) of the AccessKey/SecretKey (ak/sk) Pair
2.	SecretKey:
        User SecretKey (ak) of the AccessKey/SecretKey (ak/sk) Pair
3.	RegionName:
        User Region name where the FunctionGraph service will be used.
4.	ProjectName:
        User Project name where the FunctionGraph service will be used.
5.	ProjectId:
        User Project Id where the FunctionGraph service will be used.
6.	Timeout:
        fgs command execution timeout interval. The default value is 30seconds and the maximum value is less than or equal to 90 seconds.
7.	Endpoint:
        The HEC API-Gateway (APIGW) Endpoint URL
８.	SMNAddress:
        The HEC SMNAddress (SMNAddress)  URL
9.	APIGAddress:
        The HEC APIGAddress (SMNAddress)  URL


### code.py
```
# -*- coding:utf-8 -*-
import json
def handler (event, context):
    output = 'Hello message: ' + json.dumps(event)
    return output
```
